/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DBType;
import adql.db.exception.UnresolvedJoinException;
import java.util.ArrayList;
import java.util.Iterator;

public class DBCommonColumn
implements DBColumn {
    protected DBColumn generalColumnDesc;
    protected ArrayList<DBTable> lstCoveredTables = new ArrayList();

    public DBCommonColumn(DBColumn dBColumn, DBColumn dBColumn2) throws UnresolvedJoinException {
        Iterator<DBTable> iterator;
        if (dBColumn.getDatatype() != null && dBColumn2.getDatatype() != null && !dBColumn.getDatatype().isCompatible(dBColumn2.getDatatype())) {
            throw new UnresolvedJoinException("JOIN impossible: incompatible column types when trying to join the columns " + dBColumn.getADQLName() + " (" + dBColumn.getDatatype() + ") and " + dBColumn2.getADQLName() + " (" + dBColumn2.getDatatype() + ")!");
        }
        if (dBColumn instanceof DBCommonColumn) {
            this.generalColumnDesc = ((DBCommonColumn)dBColumn).generalColumnDesc;
            iterator = ((DBCommonColumn)dBColumn).getCoveredTables();
            while (iterator.hasNext()) {
                this.addCoveredTable(iterator.next());
            }
        } else {
            this.generalColumnDesc = dBColumn.copy(dBColumn.getDBName(), dBColumn.getADQLName(), null);
            this.addCoveredTable(dBColumn.getTable());
        }
        if (dBColumn2 instanceof DBCommonColumn) {
            iterator = ((DBCommonColumn)dBColumn2).getCoveredTables();
            while (iterator.hasNext()) {
                this.addCoveredTable(iterator.next());
            }
        } else {
            this.addCoveredTable(dBColumn2.getTable());
        }
    }

    public DBCommonColumn(DBCommonColumn dBCommonColumn, String string, String string2) {
        this.generalColumnDesc = dBCommonColumn.generalColumnDesc.copy(string, string2, null);
        this.lstCoveredTables = (ArrayList)dBCommonColumn.lstCoveredTables.clone();
    }

    @Override
    public final String getADQLName() {
        return this.generalColumnDesc.getADQLName();
    }

    @Override
    public final String getDBName() {
        return this.generalColumnDesc.getDBName();
    }

    @Override
    public final DBType getDatatype() {
        return this.generalColumnDesc.getDatatype();
    }

    @Override
    public final DBTable getTable() {
        return null;
    }

    public final Iterator<DBTable> getCoveredTables() {
        return this.lstCoveredTables.iterator();
    }

    protected void addCoveredTable(DBTable dBTable) {
        if (dBTable != null) {
            this.lstCoveredTables.add(dBTable);
        }
    }

    @Override
    public DBColumn copy(String string, String string2, DBTable dBTable) {
        return this.generalColumnDesc.copy(string, string2, dBTable);
    }
}

